<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'status', 'short_description', 'description', 'start_date', 'end_date', 'start_time', 'price');
    protected $visible = array('title', 'status', 'short_description', 'description', 'end_date', 'start_time', 'price');

    public function organization()
    {
        return $this->belongsTo('App\Models\Organization');
    }

    public function photos()
    {
        return $this->morphMany('App\Models\Attachment');
    }

    public function tickets()
    {
        return $this->hasMany('App\Models\Ticket');
    }

    public function rates()
    {
        return $this->morphMany('App\Models\Rate');
    }

}